﻿<?php
header('Content-Type: text/html; charset=utf-8');
//include('../include/conexion.php');
  /*Funciones a pasar a otro archivo*/
  function puntos_cm ($medida, $resolucion=72){
    // 2.54 cm / pulgada
    return ($medida/(2.54))*$resolucion;
  }
  function set_logo(&$pdf){
    $pdf->addJpegFromFile("LOGO.jpg",10,740,120);//logo de la factura
  }


  function set_folio_ruta(&$pdf, &$doc){
    $addendas = $doc->getElementsByTagName("Datos");
    $sbase="";
    foreach($addendas as $addenda){
      $sbase=$addenda->getAttribute('SBase');
      $folio=$addenda->getAttribute('ip');
      $ruta=$addenda->getAttribute('codCliente');
    } 

    $pdf->addText(puntos_cm(17.4),puntos_cm(27.3),8,"Folio:");
    $pdf->addText(puntos_cm(18.3),puntos_cm(27.3),8,$folio);

    $pdf->addText(puntos_cm(17.4),puntos_cm(26.9),8,"Ruta:");
    $pdf->addText(puntos_cm(18.4),puntos_cm(26.9),8,$ruta);
  }

  function set_encabezado(&$pdf, &$doc){
    $comprobante  = $doc->getElementsByTagName("Comprobante");
    foreach($comprobante as $emi){
      $version    = $emi->getAttribute('Version');
      $fecha      = $emi->getAttribute('Fecha');
      $sello      = $emi->getAttribute('Sello');
      $tcomp      = $emi->getAttribute('TipoDeComprobante');
      $fdp        = $emi->getAttribute('FormaPago');
      $certifi    = $emi->getAttribute('NoCertificado');
      $subtotalf  = $emi->getAttribute('SubTotal');
      $descuen    = $emi->getAttribute('Descuento');
      $moneda     = $emi->getAttribute('Moneda');
      $totalf     = $emi->getAttribute('Total');
      $serie      = $emi->getAttribute('Serie');
      $folio      = $emi->getAttribute('Folio');
      $metodoDePago       = $emi->getAttribute('MetodoPago');
      $LugarExpedicion    = $emi->getAttribute('LugarExpedicion');
    }


        // $FechaPago=$detalle_pago_xml->getAttribute('FechaPago');
        // $FormaDePagoP=$detalle_pago_xml->getAttribute('FormaDePagoP');

    //if($tcomp=='I'){
      $tcomp=$tcomp.'-PAGO';
    // }else{
    //   $tcomp=$tcomp.'-EGRESO';
    // }

    $timbres = $doc->getElementsByTagName("TimbreFiscalDigital");
    foreach($timbres as $tim){
      $cert_SAT       = $tim->getAttribute('NoCertificadoSAT'); 
      $tim_fecha      = $tim->getAttribute('FechaTimbrado'); 
      $tim_uuid       = $tim->getAttribute('UUID'); 
    }

    $metodoDePago_txt="";
    switch ($metodoDePago) {
      case 'PUE':
        $metodoDePago_txt='Pago en una sola exhibición';
      break;
      case 'PPD':
        $metodoDePago_txt='Pago en parcialidades o diferido';
      break;
      default:
        $metodoDePago_txt='Pago en una sola exhibición';
      break;
    }
    $metodoDePago_txt=$metodoDePago.' - '.$metodoDePago_txt;

    $fdp_txt='';
    switch ($fdp) {
      case '01':
        $fdp_txt='Efectivo';
      break;
      case '02':
        $fdp_txt='Cheque nominativo';
      break;
      case '03':
        $fdp_txt='Transferencia electrónica de fondos';
      break;
      case '04':
        $fdp_txt='Tarjeta de crédito';
      break;
      case '05':
        $fdp_txt='Monedero electrónico';
      break;
      case '06':
        $fdp_txt='Dinero electrónico';
      break;
      case '08':
        $fdp_txt='Vales de despensa';
      break;
      case '12':
        $fdp_txt='Dación en pago';
      break;
      case '13':
        $fdp_txt='Pago por subrogación';
      break;
      case '14':
        $fdp_txt='Pago por consignación';
      break;
      case '15':
       $fdp_txt='Condonación';
      break;
      case '17':
        $fdp_txt='Compensación';
      break;
      case '23':
        $fdp_txt='Novación';
      break;
      case '24':
        $fdp_txt='Confusión';
      break;
      case '25':
        $fdp_txt='Remisión de deuda';
      break;
      case '26':
        $fdp_txt='Prescripción o caducidad';
      break;
      case '27':
        $fdp_txt='A satisfacción del acreedor';
      break;
      case '28':
        $fdp_txt='Tarjeta de débito';
      break;
      case '29':
        $fdp_txt='Tarjeta de servicios';
      break;
      case '30':
        $fdp_txt='Aplicación de anticipos';
      break;
      case '31':
        $fdp_txt='Intermediario pagos';
      break;
      case '99':
        $fdp_txt='Por definir';
      break;
      default:
        $fdp_txt='Por definir';
      break;
    }
    $fdp_txt=utf8_decode($fdp.' - '.$fdp_txt);

    //Serie y folio (cuadro esquina suoerior derecha)
    //$pdf->addText(puntos_cm(17.5),puntos_cm(28.2),8,$serie."-".$folio);
    $pdf->addText(puntos_cm(17.5),puntos_cm(28.2),8,$serie."-".$folio);

    $pdf->addText(puntos_cm(6),puntos_cm(28.6),7,"Tipo de Comprobante");
    $pdf->addText(puntos_cm(10),puntos_cm(28.6),7,$tcomp);

    $pdf->addText(puntos_cm(6),puntos_cm(28.3),7,utf8_decode("Versión")); 
    $pdf->addText(puntos_cm(10),puntos_cm(28.3),7,$version);

    $pdf->addText(puntos_cm(6),puntos_cm(28.0),7,utf8_decode("Fecha y Hora de Certificación"));
    $pdf->addText(puntos_cm(10),puntos_cm(28.0),7,$tim_fecha);

    $pdf->addText(puntos_cm(6),puntos_cm(27.6),7,"Folio Fiscal");
    $pdf->addText(puntos_cm(10),puntos_cm(27.6),7,$tim_uuid);

    $pdf->addText(puntos_cm(6),puntos_cm(27.3),7,"Certificado SAT");
    $pdf->addText(puntos_cm(10),puntos_cm(27.3),7,$cert_SAT);

    $pdf->addText(puntos_cm(6),puntos_cm(27.0),7,utf8_decode("Fecha de elaboración "));
    $pdf->addText(puntos_cm(10),puntos_cm(27.0),7,$fecha);

    $pdf->addText(puntos_cm(6),puntos_cm(26.7),7,"Certificado Emisor");
    $pdf->addText(puntos_cm(10),puntos_cm(26.7),7,$certifi);

    // $pdf->addText(puntos_cm(6),puntos_cm(26.4),7,utf8_decode("Método de pago"));
    // $pdf->addText(puntos_cm(10),puntos_cm(26.4),7,$metodoDePago_txt);

    // $pdf->addText(puntos_cm(6),puntos_cm(26.1),7,"Forma de Pago");
    // $pdf->addText(puntos_cm(10),puntos_cm(26.1),7,$fdp_txt);
  }

  function get_cadena_original(&$doc){
    /*Armado de cadena original*/
    $timbres = $doc->getElementsByTagName("TimbreFiscalDigital");
    foreach($timbres as $tim){
      $version_timbre = $tim->getAttribute('Version');
      $sello_SAT      = $tim->getAttribute('SelloSAT');
      $cert_SAT       = $tim->getAttribute('NoCertificadoSAT'); 
      $sello_CFD      = $tim->getAttribute('SelloCFD'); 
      $tim_fecha      = $tim->getAttribute('FechaTimbrado'); 
      $tim_uuid       = $tim->getAttribute('UUID'); 
    }
    $cadena_original_armada="||1.1|".$tim_uuid ."|".$tim_fecha."|".$sello_CFD."|".$cert_SAT."|";
    return $cadena_original_armada;
  }

  function set_receptor_emisor(&$pdf, &$doc){









  // # Datos de Emisor
  // $emisor = $doc->getElementsByTagName("Emisor");
  // foreach( $emisor as $emi ){
  //   $nombre_emi = $emi->getAttribute('Nombre');
  //   $rfc_emi    = $emi->getAttribute('Rfc');
  //   $regfiscal = $emi->getAttribute("RegimenFiscal");
  //   $regimen =$regfiscal;
  // }
          
  // # Datos de Receptor
  // $receptor = $doc->getElementsByTagName("Receptor");
  // foreach($receptor as $emi){    
  //   $receptor_nombre = $emi->getAttribute('Nombre');
  //   $receptor_rfc    = $emi->getAttribute('Rfc'); 
  //   $UsoCFDI         = $emi->getAttribute('UsoCFDI');       
  // }   
       

    /*Emisor*/
    $emisor = $doc->getElementsByTagName("Emisor");
    foreach($emisor as $emi){
      $nombre_emi = utf8_decode($emi->getAttribute('Nombre'));
      $rfc_emi = $emi->getAttribute('Rfc');
    }
    $comprobante  = $doc->getElementsByTagName("Comprobante");
    foreach($comprobante as $emi){
      $LugarExpedicion_emi    = $emi->getAttribute('LugarExpedicion');
    }



    $pdf->addText(puntos_cm(0.7),puntos_cm(25.4),6,"EMISOR");
    
    $pdf->addText(puntos_cm(0.7),puntos_cm(25.1),6,"NOMBRE");
    $pdf->addText(puntos_cm(3),puntos_cm(25.1),6,$nombre_emi);

    $pdf->addText(puntos_cm(0.7),puntos_cm(24.8),6,"RFC");  
    $pdf->addText(puntos_cm(3),puntos_cm(24.8),6,$rfc_emi);

    // $pdf->addText(puntos_cm(0.7),puntos_cm(24.5),6,"EXPEDIDO EN"); 
    // $pdf->addText(puntos_cm(3),puntos_cm(24.5),6,$LugarExpedicion_emi);



    
    


    //Los nuevos campos
    $pdf->addText(puntos_cm(0.7),puntos_cm(24.5),6,"USO CFDI");
    $pdf->addText(puntos_cm(3),puntos_cm(24.5),6, "G03 - gastos en general");
   
    $pdf->addText(puntos_cm(0.7),puntos_cm(24.2),6,"CALLE"); 
    $pdf->addText(puntos_cm(3),puntos_cm(24.2),6, "FRANCISCO Y MADERO");

    $pdf->addText(puntos_cm(0.7),puntos_cm(23.9),6,"NUMERO EXT.");
    $pdf->addText(puntos_cm(3),puntos_cm(23.9),6, "1012");

    // $pdf->addText(puntos_cm(6),puntos_cm(24.2),6,"NUMERO INT."); 
    // $pdf->addText(puntos_cm(8),puntos_cm(24.2),6,$var);

    $pdf->addText(puntos_cm(0.7),puntos_cm(23.6),6,"COLONIA"); 
    $pdf->addText(puntos_cm(3),puntos_cm(23.6),6, "AQUILES SERDAN"); 

    $pdf->addText(puntos_cm(0.7),puntos_cm(23.3),6,"MUN. DEL."); 
    $pdf->addText(puntos_cm(3),puntos_cm(23.3),6, "TEHUACAN"); 

    $pdf->addText(puntos_cm(0.7),puntos_cm(23),6,"ESTADO"); 
    $pdf->addText(puntos_cm(3),puntos_cm(23),6, "PUEBLA"); 

    $pdf->addText(puntos_cm(0.7),puntos_cm(22.7),6,"PAIS"); 
    $pdf->addText(puntos_cm(3),puntos_cm(22.7),6, "MEXICO"); 









    /*Emisor*/

    /*Receptor*/
    $receptor = $doc->getElementsByTagName("Receptor");
    foreach($receptor as $rec){
      $nombre_rec=$rec->getAttribute('Nombre');
      $rfc_rec=$rec->getAttribute('Rfc');
      $usocfdi_txt='';
      switch ($rec->getAttribute('UsoCFDI')) {
        case 'G01':
          $usocfdi_txt='Adquisición de mercancias';
        break;
        case 'G02':
         $usocfdi_txt='Devoluciones, descuentos o bonificaciones';
        break;
        case 'G03':
          $usocfdi_txt='Gastos en general';
        break;
        case 'I01':
          $usocfdi_txt='Construcciones';
        break;
        case 'I02':
          $usocfdi_txt='Mobilario y equipo de oficina por inversiones';
        break;
        case 'I03':
          $usocfdi_txt='Equipo de transporte';
        break;
        case 'I04':
          $usocfdi_txt='Equipo de computo y accesorios';
        break;
        case 'I05':
          $usocfdi_txt='Dados, troqueles, moldes, matrices y herramental';
        break;
        case 'I06':
          $usocfdi_txt='Comunicaciones telefónicas';
        break;
        case 'I07':
          $usocfdi_txt='Comunicaciones satelitales';
        break;
        case 'I08':
          $usocfdi_txt='Otra maquinaria y equipo';
        break;
        case 'D01':
          $usocfdi_txt='Honorarios médicos, dentales y gastos hospitalarios.';
        break;
        case 'D02':
         $usocfdi_txt='Gastos médicos por incapacidad o discapacidad';
        break;
        case 'D03':
          $usocfdi_txt='Gastos funerales.';
        break;
        case 'D04':
          $usocfdi_txt='Donativos.';
        break;
        case 'D05':
         $usocfdi_txt='Intereses reales efectivamente pagados por créditos hipotecarios (casa habitación).';
        break;
        case 'D06':
          $usocfdi_txt='Aportaciones voluntarias al SAR.';
        break;
        case 'D07':
          $usocfdi_txt='Primas por seguros de gastos médicos.';
        break;
        case 'D08':
          $usocfdi_txt='Gastos de transportación escolar obligatoria.';
        break;
        case 'D09':
          $usocfdi_txt='Depósitos en cuentas para el ahorro, primas que tengan como base planes de pensiones.';
        break;
        case 'D10':
          $usocfdi_txt='Pagos por servicios educativos (colegiaturas)';
        break;
        case 'P01':
          $usocfdi_txt='Por definir';
        break;
        default:
          $usocfdi_txt='Por definir';
        break;
      }
      $usocfdi_txt=utf8_decode($rec->getAttribute('UsoCFDI') .' - '.$usocfdi_txt);        
    }

    $pdf->addText(puntos_cm(11.2),puntos_cm(25.4),6,"RECEPTOR");
    $pdf->addText(puntos_cm(11.2),puntos_cm(25.1),6,"NOMBRE");
    $tamanno = strlen($nombre_rec);  
    if($tamanno <= 45){
      $pdf->addText(puntos_cm(13.2),puntos_cm(25.1),6,utf8_decode($nombre_rec));
    }elseif($tamanno > 45){
      $pdf->addText(puntos_cm(13.2),puntos_cm(25.1),5,utf8_decode($nombre_rec));
    }

    $pdf->addText(puntos_cm(11.2),puntos_cm(24.8),6,"RFC");
    $pdf->addText(puntos_cm(13.2),puntos_cm(24.8),6,$rfc_rec);

    $pdf->addText(puntos_cm(11.2),puntos_cm(24.5),6,"USO CFDI");
    $pdf->addText(puntos_cm(13.2),puntos_cm(24.5),6,$usocfdi_txt);



  //Los nuevos campos
  $calle_db='';
  $numext_db='';
  $numint_db='';
  $colonia_db='';
  $mundel_db='';
  $estado_db='';
  $pais_db='';

  $query = "SELECT * FROM CLIENTES WHERE rfc='".$rfc_rec."' LIMIT 1";
  $conexion=conexion::singleton();
  $result_query=$conexion->execute($query);
  if (!$result_query) {
    die('No se pudo consultar:' . mysql_error());
  }else{
    $row = mysql_fetch_array($result_query, MYSQL_NUM);
    $calle_db=$row[4];
    $numext_db=$row[6];
    $numint_db=$row[7];
    $colonia_db=$row[5];
    $mundel_db=$row[8];
    $estado_db=$row[10];
    $pais_db=$row[12];
  }

  $pdf->addText(puntos_cm(11.2),puntos_cm(24.2),6,"CALLE"); 
  $pdf->addText(puntos_cm(13.2),puntos_cm(24.2),6, $calle_db);

  $pdf->addText(puntos_cm(11.2),puntos_cm(23.9),6,"NUMERO EXT.");
  $pdf->addText(puntos_cm(13.2),puntos_cm(23.9),6, $numext_db);

  $pdf->addText(puntos_cm(17.2),puntos_cm(24.2),6,"NUMERO INT."); 
  $pdf->addText(puntos_cm(18.9),puntos_cm(24.2),6,$numint_db);

  $pdf->addText(puntos_cm(11.2),puntos_cm(23.6),6,"COLONIA"); 
  $pdf->addText(puntos_cm(13.2),puntos_cm(23.6),6, $colonia_db); 

  $pdf->addText(puntos_cm(11.2),puntos_cm(23.3),6,"MUN. DEL."); 
  $pdf->addText(puntos_cm(13.2),puntos_cm(23.3),6, $mundel_db); 

  $pdf->addText(puntos_cm(11.2),puntos_cm(23),6,"ESTADO"); 
  $pdf->addText(puntos_cm(13.2),puntos_cm(23),6, $estado_db); 

  $pdf->addText(puntos_cm(11.2),puntos_cm(22.7),6,"PAIS"); 
  $pdf->addText(puntos_cm(13.2),puntos_cm(22.7),6, $pais_db); 





  }

  function set_totales(&$pdf, &$doc){
    $titla = array(
      'uno'=>'<b></b>',
      'dos'=>'<b></b>', 
      'tres'=>'<b></b>',
      'cuatro'=>'<b></b>',
    ); 
    $optionsa = array(
      'shadeCol'=>array(0.8,0.9,0.9),
      'xOrientation'=>'center',
      'width'=>540,
      'shaded'=> 0,
      'showLines'=> 0,
      'fontSize' => 7,
      'rowGap' => 0,
      'cols'=>array(
        'uno'=>array('justification'=>'center','width'=>40,'fontSize'=> 8),
        'dos'=>array('justification'=>'left','width'=>300,'fontSize'=> 8),
        'tres'=>array('justification'=>'right','width'=>100,'fontSize'=> 8),
        'cuatro'=>array('justification'=>'right','width'=>100,'fontSize'=> 8)
      )
    );

    $comprobante  = $doc->getElementsByTagName("Comprobante");
    foreach($comprobante as $emi){
      $subtotalf  = $emi->getAttribute('SubTotal');
      $descuen    = $emi->getAttribute('Descuento');
      $totalf     = $emi->getAttribute('Total');
    }

    $datasa[] = array('uno'=>'','dos'=>'','tres'=>' IMPORTE :','cuatro'=>number_format($subtotalf,2)." ");      
    $datasa[] = array('uno'=>'','dos'=>'','tres'=>'DESCUENTO :','cuatro'=>number_format($descuen,2)." ");     
    $datasa[] = array('uno'=>'','dos'=>'','tres'=>" SUBTOTAL  :",'cuatro'=>number_format($subtotalf - $descuen,2) ." ");
    $datasa[] = array('uno'=>'','dos'=>'','tres'=>" IVA (16%)  :",'cuatro'=>number_format((($subtotalf - $descuen) * 0.16),2) ." ");        
    // en el caso de los impuestos y de quien tiene mas de un impuesto colocamos los valores correspondientes

    $importe_traslado=number_format(0,2);
    $impuestos  = $doc->getElementsByTagName("Impuestos");

    foreach( $impuestos as $emi ){
      $retenciones = $emi->getElementsByTagName("Retenciones");
      foreach( $retenciones as $detalle ){
        $retencion = $detalle->getElementsByTagName('Retencion');
        foreach( $retencion as $ivas ){
          $datasa[] = array('uno'=>'','dos'=>'','tres'=>"Ret. ".$ivas->getAttribute('impuesto')." :",'cuatro'=>number_format($ivas->getAttribute('importe'),2)." "); 
        }
      }  
      $traslados = $emi->getElementsByTagName("Traslados");
      foreach($traslados as $detalle){
        $traslado = $detalle->getElementsByTagName('Traslado');
        foreach($traslado as $ivas){
          $importe_traslado=number_format($ivas->getAttribute('Importe'),2);
        }
      }
    }  
    $datasa[] = array('uno'=>'','dos'=>'','tres'=>'TOTAL :','cuatro'=>number_format($totalf,2) ." ");
    $pdf->ezSetY(puntos_cm(10.8)); #7.8
    $pdf->ezTable($datasa, $titla, '', $optionsa);
  }

  function set_sellos_qr(&$pdf, &$doc){
    $timbres = $doc->getElementsByTagName("TimbreFiscalDigital");
    foreach($timbres as $tim){
      $version_timbre = $tim->getAttribute('Version');
      $sello_SAT      = $tim->getAttribute('SelloSAT');
      $cert_SAT       = $tim->getAttribute('NoCertificadoSAT'); 
      $sello_CFD      = $tim->getAttribute('SelloCFD'); 
      $tim_fecha      = $tim->getAttribute('FechaTimbrado'); 
      $tim_uuid       = $tim->getAttribute('UUID'); 
    }

    $comprobante  = $doc->getElementsByTagName("Comprobante");
    foreach($comprobante as $emi){
      $totalf     = $emi->getAttribute('Total');
    }

    $receptor = $doc->getElementsByTagName("Receptor");
    foreach($receptor as $rec){
      $rfc_recp=$rec->getAttribute('Rfc');
    }

    $emisor = $doc->getElementsByTagName("Emisor");
    foreach($emisor as $emi){
      $rfc_emi = $emi->getAttribute('Rfc');
    }

    // colocamos el sello y la cadena original en la parte inferior
    $pdf->ezSetY(265); #165 Sello Digital
    $titlesx = array('sell'=>'<b>SELLO DIGITAL DEL EMISOR :</b>'); 
    $datax[] = array('sell'=>$sello_CFD);
    $options = array(
      'showLines'=> 0, 
      'xPos'=>360,
      'xOrientation'=>'center',
      'width'=>420,
      'fontSize' => 6
    );
        
    $pdf->ezTable($datax, $titlesx, '', $options);
    $tis = array('sell'=>'<b>SELLO DIGITAL DEL SAT :</b>'); 
    $datar[] = array('sell'=>$sello_SAT);
    $optionsr = array(
      'showLines'=> 0, 
      'xPos'=>360,
      'xOrientation'=>'center',
      'width'=>420,
      'fontSize' => 6
    );
    $pdf->ezSetY(227); #125 Sello Digital
    $pdf->ezTable($datar, $tis, '', $optionsr);
    
    $pdf->ezSetY(190); #100 Cadena Original
    $titles = array('cadena_o'=>utf8_decode('<b>CADENA ORIGINAL DEL COMPLEMENTO DE CERTIFICACIÓN DIGITAL DEL SAT :</b>')); 
    $data[] = array('cadena_o'=>get_cadena_original($doc));
    $options = array(
      'showLines'=> 0,
      'xPos'=>360,
      'xOrientation'=>'center',
      'width'=>420,
      'fontSize' => 6
    );
    $pdf->ezTable($data, $titles,'', $options);
    $totalf = number_format($totalf,6,'.','');
    list($cantidad,$decimales) = split( '[.__]', $totalf );
    $cuantos_caract = strlen($cantidad);
    if($cuantos_caract <= 10){
      for($i=$cuantos_caract + 1 ;$i<=10;$i++){
        $pos .= "0" ;
      }  
      $pos = $pos.$cantidad.".".$decimales;  
    }
    $totalf = $pos;

    $pdf->ezSetY(150); # posicionamos el cbb 150
    ##################################### *** RECOMENDADO *** #################################################  
    include("../../prueba_cbb_comprobantes.php");
    ImageCopyResized($output_image,$base_image,0,0,0,0,$qrcode_image_size,$qrcode_image_size,$mib,$mib);
    if ($qrcode_image_type == "jpeg"){
      ImageJpeg($output_image,"../../response_cbb/cbb_".$clave.".jpg");
    }else{
      ImagePng($output_image,"../../response_cbb/cbb_".$clave.".png");
    } 
    $pdf->addJpegFromFile("../../response_cbb/cbb_".$clave.".jpg",5,135,120,120); # 5,55,120,120    
    ############################################################################################################  
  }

  function set_cfdi_relacionados(&$pdf, &$doc){
    $cfdirelacionados_tipoRelacion="";
    $cfdirelacionados_node = $doc->getElementsByTagName("CfdiRelacionados");
    foreach($cfdirelacionados_node as $element ){
      $cfdirelacionados_tipoRelacion = $element->getAttribute('TipoRelacion');

      $relacionados = $element->getElementsByTagName("CfdiRelacionado");

      $cfdi_relacionados="";
      foreach($relacionados as $relacionado){
        $cfdi_relacionados.=$relacionado->getAttribute('UUID')." ";
      }
    }

    if($cfdirelacionados_tipoRelacion<>''){
      switch ($cfdirelacionados_tipoRelacion) {
        case "01":
          $tipo_relacion="01 Nota de crédito de los documentos relacionados";
          break;
        case "02":
          $tipo_relacion="02 Nota de débito de los documentos relacionados";
          break;
        case "03":
          $tipo_relacion="03 Devolución de mercancía sobre facturas o traslados previos";
          break;
        case "04":
          $tipo_relacion="04 Sustitución de los CFDI previos";
          break;
        case "05":
          $tipo_relacion="05 Traslados de mercancias facturados previos";
          break;
        case "06":
          $tipo_relacion="06 Factura generada por los traslados previos";
          break;
        case "07":
          $tipo_relacion="07 CFDI por aplicación de anticipo";
          break;
        
        default:
          $tipo_relacion="";
          break;
      }

      $pdf->addText(puntos_cm(0.7),puntos_cm(23.7),6,utf8_decode("<b>TIPO RELACIÓN: ".$tipo_relacion."</b>"));
      $pdf->ezSetY(670); #CFDI RELACIONADOS
      $titles_relacionados = array('relacion'=>'<b>CFDI RELACIONADOS:</b>'); 
      $data_relacionados[] = array('relacion'=>$cfdi_relacionados);
      $options_relacionados = array(
        'showLines'=> 0, 
        'xPos'=>20,
        'xOrientation'=>'right',
        'width'=>560,
        'fontSize' => 6
      );
      $pdf->ezTable($data_relacionados, $titles_relacionados, '', $options_relacionados);
    }

  }



  function set_regimen_fiscal(&$pdf, &$doc){
    $emisor = $doc->getElementsByTagName("Emisor");
    foreach($emisor as $emi){
      $regfiscal = $emi->getAttribute('RegimenFiscal');
    }
    
    switch ($regfiscal) {
      case '601':
        $regfiscal_txt='General de Ley Personas Morales';
        break;
      case '603':
        $regfiscal_txt='Personas Morales con Fines no Lucrativos';
        break;
      case '605':
        $regfiscal_txt='Sueldos y Salarios e Ingresos Asimilados a Salarios';
        break;
      case '606':
        $regfiscal_txt='Arrendamiento';
        break;
      case '608':
        $regfiscal_txt='Demás ingresos';
        break;
      case '609':
        $regfiscal_txt='Consolidación';
        break;
      case '610':
        $regfiscal_txt='Residentes en el Extranjero sin Establecimiento Permanente en México';
        break;
      case '611':
        $regfiscal_txt='Ingresos por Dividendos (socios y accionistas)';
        break;
      case '612':
        $regfiscal_txt='Personas Físicas con Actividades Empresariales y Profesionales';
        break;
      case '614':
        $regfiscal_txt='Ingresos por intereses';
        break;
      case '616':
        $regfiscal_txt='Sin obligaciones fiscales';
        break;
      case '620':
        $regfiscal_txt='Sociedades Cooperativas de Producción que optan por diferir sus ingresos';
        break;
      case '621':
        $regfiscal_txt='Incorporación Fiscal';
        break;
      case '622':
        $regfiscal_txt='Actividades Agrícolas, Ganaderas, Silvícolas y Pesqueras';
        break;
      case '623':
        $regfiscal_txt='Opcional para Grupos de Sociedades';
        break;
      case '624':
        $regfiscal_txt='Coordinados';
        break;
      case '628':
        $regfiscal_txt='Hidrocarburos';
        break;
      case '607':
        $regfiscal_txt='Régimen de Enajenación o Adquisición de Bienes';
        break;
      case '629':
        $regfiscal_txt='De los Regímenes Fiscales Preferentes y de las Empresas Multinacionales';
        break;
      case '630':
        $regfiscal_txt='Enajenación de acciones en bolsa de valores';
        break;
      case '615':
        $regfiscal_txt='Régimen de los ingresos por obtención de premios';
        break;
      default:
        $regfiscal_txt='';
        break;
    }

    $regfiscal_txt=utf8_decode($regfiscal.' - '.$regfiscal_txt);
    $pdf->addText(puntos_cm(0.5),puntos_cm(19.7),6,"REGIMEN : ".$regfiscal_txt." </b>");
    $pdf->ezTable($data, $titles, '', $opt); 
  }



  function getformapago($fdp){
     $fdp_txt='';
    switch ($fdp) {
      case '01':
        $fdp_txt='Efectivo';
      break;
      case '02':
        $fdp_txt='Cheque nominativo';
      break;
      case '03':
        $fdp_txt='Transferencia electrónica de fondos';
      break;
      case '04':
        $fdp_txt='Tarjeta de crédito';
      break;
      case '05':
        $fdp_txt='Monedero electrónico';
      break;
      case '06':
        $fdp_txt='Dinero electrónico';
      break;
      case '08':
        $fdp_txt='Vales de despensa';
      break;
      case '12':
        $fdp_txt='Dación en pago';
      break;
      case '13':
        $fdp_txt='Pago por subrogación';
      break;
      case '14':
        $fdp_txt='Pago por consignación';
      break;
      case '15':
       $fdp_txt='Condonación';
      break;
      case '17':
        $fdp_txt='Compensación';
      break;
      case '23':
        $fdp_txt='Novación';
      break;
      case '24':
        $fdp_txt='Confusión';
      break;
      case '25':
        $fdp_txt='Remisión de deuda';
      break;
      case '26':
        $fdp_txt='Prescripción o caducidad';
      break;
      case '27':
        $fdp_txt='A satisfacción del acreedor';
      break;
      case '28':
        $fdp_txt='Tarjeta de débito';
      break;
      case '29':
        $fdp_txt='Tarjeta de servicios';
      break;
      case '30':
        $fdp_txt='Aplicación de anticipos';
      break;
      case '31':
        $fdp_txt='Intermediario pagos';
      break;
      case '99':
        $fdp_txt='Por definir';
      break;
      default:
        $fdp_txt='Por definir';
      break;
    }
    $fdp_txt=utf8_decode($fdp.' - '.$fdp_txt);

    return $fdp_txt;
  }

  function set_pagare(&$pdf, &$doc){
    
    $comprobante  = $doc->getElementsByTagName("Comprobante");
    foreach($comprobante as $emi){
      $totalf = $emi->getAttribute('Total');
      $fecha      = $emi->getAttribute('Fecha');
      $fdp        = $emi->getAttribute('FormaPago');
    }
    $letras=cantidad_a_texto($totalf);

    $pdf->ezSetY(puntos_cm(10.2)); #7.2
 

    $pdf->addText(puntos_cm(1),puntos_cm(1.3),5,"EFECTOS FISCALES AL PAGO"); # MAXIMO 26 PARTIDAS A LA FACTURA 
    $pdf->addText(puntos_cm(1),puntos_cm(3.9),5,"MEXICO D.F. A: "."<b>".$fecha."</b>"." DEBO Y PAGARE INCONDICIONALMENTE A AUTOPARTES GARCIA JIMENEZ S.A. DE C.V., EN LA  CIUDAD DE  TEHUACAN PUEBLA  O  EN  CUALQUIER OTRA  QUE  ME REQUIERA ");   
    $pdf->addText(puntos_cm(1),puntos_cm(3.6),5,"LA  CANTIDAD  DE ".number_format($totalf,2).' ('.$letras.')');
    $pdf->addText(puntos_cm(1),puntos_cm(3.3),5,"VALOR RECIBIDO EN MERCANCIA A MI EMTERA SATISFACCION, SI NO FUESE CUBIERTO A SU PRESENTACION CAUSARA UN INTERES MORATORIO DEL 10% MENSUAL. ");   
    $pdf->addText(puntos_cm(1),puntos_cm(3.0),5,"LA FIRMA EN CUALQUIER PARTE DE ESTA FACTURA PAGARE HACE. MANIFIESTA MI CONFORMIDAD Y RECONOCIMIENTO PLENO DEL ADEUDO. ASI MISMO EN TERMINOS DEL ARTICULO 9° FRACCION  II  DE LA LEY  GENERAL");
    $pdf->addText(puntos_cm(1),puntos_cm(2.7),5,"DE TITULOS Y OPERACIONES DE CREDITO. OTORGO REPRESENTACION Y ME OBLIGO RESPECTO DE QUIEN (ES) A MI NOMBRE Y/O REPRESENTACION RECIBAN MERCANCIAS. Y/O HAGAN PEDIDOS. Y/O SUSCRIBAN TITULOS ");
    $pdf->addText(puntos_cm(1),puntos_cm(2.4),5,"DE CREDITO. Y/O FACTURAS A SER CARGADAS A MI CUENTA. HACIENDOME RESPONSABLE DE LA LIQUIDACION DE LOS MISMOS. EN TANTO NO DE AVISO POR ESCRITO DE MODIFICACION A DICHAS AUTORIZACIONES. ");
    $pdf->addText(puntos_cm(1),puntos_cm(2.0),8,"NOMBRE Y FIRMA DE RECIBIDO Y ACEPTADO: _________________________________________________________________________________. ");
    $pdf->addText(puntos_cm(1),puntos_cm(1.7),4,"<i>CANTIDAD CON LETRA </i>"." ".' ('.$letras.')');   
    $pdf->addText(puntos_cm(5),puntos_cm(1.3),5,utf8_decode("<b>*** ESTE DOCUMENTO ES UNA REPRESENTACIÓN IMPRESA DE UN CFDI ***</b>"));
    //$pdf->addText(puntos_cm(15),puntos_cm(1.3),5,"<b>".utf8_decode($fdp)."</b>");
    //$pdf->addText(puntos_cm(0.5),puntos_cm(21.9),6," ".$LEYENDA1." | ".$LEYENDA2." ");  
  }

  function set_detalle_pago(&$pdf, &$doc){



    $FechaPago='';
    $FormaDePagoP='';
    $MonedaP='';
    $Monto='';
    $NumOperacion='';
    $RfcEmisorCtaOrd='';
    $CtaOrdenante='';
    $RfcEmisorCtaBen='';
    $CtaBeneficiario='';

    $complemento_xml  = $doc->getElementsByTagName("Complemento");
    foreach($complemento_xml as $detalle_complemento_xml){
      $pagos_xml = $detalle_complemento_xml->getElementsByTagName("Pagos");
      foreach($pagos_xml as $detalle_pagos_xml){
        $pago_xml = $detalle_pagos_xml->getElementsByTagName("Pago");
        foreach($pago_xml as $detalle_pago_xml){
          $FechaPago=($detalle_pago_xml->getAttribute('FechaPago'))?$detalle_pago_xml->getAttribute('FechaPago'):'';
          $FormaDePagoP=($detalle_pago_xml->getAttribute('FormaDePagoP'))?$detalle_pago_xml->getAttribute('FormaDePagoP'):'';
          $MonedaP=($detalle_pago_xml->getAttribute('MonedaP'))?$detalle_pago_xml->getAttribute('MonedaP'):'';
          $Monto=($detalle_pago_xml->getAttribute('Monto'))?$detalle_pago_xml->getAttribute('Monto'):'';
          $NumOperacion=($detalle_pago_xml->getAttribute('NumOperacion'))?$detalle_pago_xml->getAttribute('NumOperacion'):'';
          $RfcEmisorCtaOrd=($detalle_pago_xml->getAttribute('RfcEmisorCtaOrd'))?$detalle_pago_xml->getAttribute('RfcEmisorCtaOrd'):'';
          $CtaOrdenante=($detalle_pago_xml->getAttribute('CtaOrdenante'))?$detalle_pago_xml->getAttribute('CtaOrdenante'):'';
          $RfcEmisorCtaBen=($detalle_pago_xml->getAttribute('RfcEmisorCtaBen'))?$detalle_pago_xml->getAttribute('RfcEmisorCtaBen'):'';
          $CtaBeneficiario=($detalle_pago_xml->getAttribute('CtaBeneficiario'))?$detalle_pago_xml->getAttribute('CtaBeneficiario'):'';
        }
      }
    }

    $pdf->addText(puntos_cm(2.6),puntos_cm(11.1),6,"DETALLE DEL PAGO: BANCO ORDENANTE - BENEFICIARIO");

    $pdf->addText(puntos_cm(0.9),puntos_cm(10.6),6,"RFC Emisor Cuenta Ordenante:");
    $pdf->addText(puntos_cm(4),puntos_cm(10.6),6,$RfcEmisorCtaOrd);

    $pdf->addText(puntos_cm(0.9),puntos_cm(10.2),6,"Cuenta Ordenante:");
    $pdf->addText(puntos_cm(4),puntos_cm(10.2),6,$CtaOrdenante);

    $pdf->addText(puntos_cm(6.5),puntos_cm(10.6),6,"RFC Emisor Cuenta Beneficiario:");
    $pdf->addText(puntos_cm(9.7),puntos_cm(10.6),6,$RfcEmisorCtaBen);

    $pdf->addText(puntos_cm(6.5),puntos_cm(10.2),6,"Cuenta Beneficiario:");
    $pdf->addText(puntos_cm(9.7),puntos_cm(10.2),6,$CtaBeneficiario);



    $pdf->addText(puntos_cm(14.3),puntos_cm(11.1),6,"INFORMACION DEL PAGO");

    $pdf->addText(puntos_cm(12.5),puntos_cm(10.6),6,"Fecha de Pago:");
    $pdf->addText(puntos_cm(14.1),puntos_cm(10.6),6,$FechaPago);

    $pdf->addText(puntos_cm(12.5),puntos_cm(10.2),6,"Forma de Pago:");
    $pdf->addText(puntos_cm(14.1),puntos_cm(10.2),6,getformapago($FormaDePagoP));

    $pdf->addText(puntos_cm(12.5),puntos_cm(9.8),6,"Moneda:");
    $pdf->addText(puntos_cm(14.1),puntos_cm(9.8),6,$MonedaP);

    $pdf->addText(puntos_cm(18.2),puntos_cm(10.6),6,"Monto:");
    $pdf->addText(puntos_cm(18.9),puntos_cm(10.6),6,($Monto>0)?('$'.number_format($Monto,2)):'');

    $pdf->addText(puntos_cm(15),puntos_cm(9.8),6,"No. de Operacion:");
    $pdf->addText(puntos_cm(16.9),puntos_cm(9.8),6,$NumOperacion);

  }

  
  
  /*Funciones a pasar a otro archivo*/
?>